package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 薪资修订记录表
 * @TableName fortune_account_edit_record
 */
@TableName(value ="fortune_account_edit_record")
@Data
public class FortuneAccountEditRecord implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 薪资记录业务id
     */
    private String fortuneAccountBizId;

    /**
     * 修订人userid
     */
    private String userBizId;

    /**
     * 修订人
     */
    private String userName;

    /**
     * 修订内容
     */
    private String editContent;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建时间
     */
    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}