package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询fna请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FnaQueryRequest extends PageDto implements Serializable {

    /**
     * 创建时间开始
     */
    @Schema(description = "创建时间开始")
    private LocalDateTime startTime;

    /**
     * 创建时间结束
     */
    @Schema(description = "创建时间结束")
    private LocalDateTime endTime;

    /**
     * 流程编号
     */
    @Schema(description = "流程编号")
    private String fnaNo;

    /**
     * 状态
     */
    @Schema(description = "状态 UNCOMPLETED-未完成 COMPLETED-已完成")
    private String status;

    /**
     * 客户姓名
     */
    @Schema(description = "客户姓名")
    private String customerName;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 新单编号
     */
    @Schema(description = "新单编号")
    private String policyId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;


    private static final long serialVersionUID = 1L;
}