package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 产品计划信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-18
 */
@Getter
@Setter
@TableName("product_plan")
public class ProductPlan implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 产品计划信息表主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品计划信息表唯一业务ID
     */
    @TableField("plan_biz_id")
    private String planBizId;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 保险公司ID（产品上架信息绑定的保险公司参数）
     */
    @TableField("company_id")
    private String companyId;

    /**
     * 保险公司名称
     */
    @TableField("company_name")
    private String companyName;

    /**
     * 保险险种ID（产品上架信息绑定的保险险种参数）
     */
    @TableField("insurance_type_id")
    private String insuranceTypeId;

    /**
     * 保险险种名称
     */
    @TableField("insurance_type_name")
    private String insuranceTypeName;

    /**
     * 产品上架信息表唯一业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 产品上架信息表名称（标题）
     */
    @TableField("product_launch_name")
    private String productLaunchName;

    /**
     * 供款期数
     */
    @TableField("issue_number")
    private String issueNumber;

    /**
     * 保障年期
     */
    @TableField("guarantee_period")
    private String guaranteePeriod;

    /**
     * 保单币种
     */
    @TableField("policy_currency")
    private String policyCurrency;

    /**
     * 保单额度（重疾）
     */
    @TableField("sum_insured")
    private BigDecimal sumInsured;

    /**
     * 付款频率（字典）
     */
    @TableField("payment_frequency")
    private String paymentFrequency;

    /**
     * 每期保费
     */
    @TableField("each_issue_premium")
    private BigDecimal eachIssuePremium;

    /**
     * 首期付款方式（字典）
     */
    @TableField("initial_payment_method")
    private String initialPaymentMethod;

    /**
     * 保单征费
     */
    @TableField("policy_levy")
    private BigDecimal policyLevy;

    /**
     * 是否预缴保费: 0-否, 1-是（字典）
     */
    @TableField("is_prepay")
    private Integer isPrepay;

    /**
     * 是否追溯: 0-否, 1-是（字典）
     */
    @TableField("is_traceable")
    private Integer isTraceable;

    /**
     * 保单日期回溯: 0-否, 1-是（字典）
     */
    @TableField("is_backtrack")
    private String isBacktrack;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    @TableField("is_join")
    private Integer isJoin;

    /**
     * 红利分配方式（字典）
     */
    @TableField("dividend_distribution_method")
    private String dividendDistributionMethod;

    /**
     * 续期付款方式（字典）
     */
    @TableField("renewal_payment_method")
    private String renewalPaymentMethod;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
