package com.yd.csf.feign.fallback.premiumremittancefile;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.premiumremittancefile.ApiPremiumRemittanceFileFeignClient;
import com.yd.csf.feign.dto.premiumremittancefile.ApiPremiumRemittanceFileDto;
import com.yd.csf.feign.request.premiumremittancefile.ApiPremiumRemittanceFilePageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-保费汇款记录附件信息Feign降级处理
 */
@Slf4j
@Component
public class ApiPremiumRemittanceFileFeignFallbackFactory implements FallbackFactory<ApiPremiumRemittanceFileFeignClient> {
    @Override
    public ApiPremiumRemittanceFileFeignClient create(Throwable cause) {
        return new ApiPremiumRemittanceFileFeignClient() {
            @Override
            public Result page(ApiPremiumRemittanceFilePageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiPremiumRemittanceFileDto request) {
                return null;
            }

            @Override
            public Result edit(ApiPremiumRemittanceFileDto request) {
                return null;
            }

            @Override
            public Result del(String premiumRemittanceFileBizId) {
                return null;
            }
        };
    }
}
