package com.yd.csf.feign.dto.appointment;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 产品计划主信息
 */
@Data
public class ApiProductPlanMainInfoDto {

    /**
     * 产品计划信息表唯一业务ID
     */
    private String planBizId;

    /**
     * 保险公司ID（产品上架信息绑定的保险公司参数）
     */
    private String companyId;

    /**
     * 保险公司名称
     */
    private String companyName;

    /**
     * 保险险种ID（产品上架信息绑定的保险险种参数）
     */
    private String insuranceTypeId;

    /**
     * 保险险种名称
     */
    private String insuranceTypeName;

    /**
     * 产品上架信息表唯一业务ID
     */
    @NotBlank(message = "产品计划-基本计划-产品ID不能为空")
    private String productLaunchBizId;

    /**
     * 产品上架信息表名称（标题）
     */
    @NotBlank(message = "产品计划-基本计划-产品名称不能为空")
    private String productLaunchMainName;

    /**
     * 供款期数
     */
    private String issueNumber;

    /**
     * 保障年期
     */
    private String guaranteePeriod;

    /**
     * 保单币种
     */
    private String policyCurrency;

    /**
     * 保单额度（重疾）
     */
    private BigDecimal sumInsured;

    /**
     * 付款频率（字典）
     */
    private String paymentFrequency;

    /**
     * 每期保费
     */
    private BigDecimal eachIssuePremium;

    /**
     * 首期付款方式（字典）
     */
    private String initialPaymentMethod;

    /**
     * 保单征费
     */
    private BigDecimal policyLevy;

    /**
     * 是否预缴保费: 0-否, 1-是（字典）
     */
    private Integer isPrepay;

    /**
     * 是否追溯: 0-否, 1-是（字典）
     */
    private Integer isTraceable;

    /**
     * 保单日期回溯: 0-否, 1-是（字典）
     */
    private Integer isBacktrack;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    private Integer isJoin;

    /**
     * 红利分配方式（字典）
     */
    private String dividendDistributionMethod;

    /**
     * 续期付款方式（字典）
     */
    private String renewalPaymentMethod;
}
