package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiProductPlanService;
import com.yd.csf.feign.client.productplan.ApiProductPlanFeignClient;
import com.yd.csf.feign.dto.appointment.ApiProductPlanInfoDto;
import com.yd.csf.feign.dto.appointment.ApiProductPlanMainInfoDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预约-产品计划信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/productPlan")
@Validated
public class ApiProductPlanController implements ApiProductPlanFeignClient {

    @Autowired
    private ApiProductPlanService apiProductPlanService;

    /**
     * 编辑产品计划主体信息
     * @param apiProductPlanMainInfoDto
     * @return
     */
    @Override
    public Result edit(ApiProductPlanMainInfoDto apiProductPlanMainInfoDto) {
        return apiProductPlanService.edit(apiProductPlanMainInfoDto);
    }

    /**
     * 编辑产品计划信息
     * @param apiProductPlanInfoDto
     * @return
     */
    @Override
    public Result editPlan(ApiProductPlanInfoDto apiProductPlanInfoDto) {
        return apiProductPlanService.editPlan(apiProductPlanInfoDto);
    }

    /**
     * 产品计划详情
     * @param planBizId
     * @return
     */
    @Override
    public Result<ApiProductPlanInfoDto> detail(String appointmentBizId, String planBizId) {
        return apiProductPlanService.detail(appointmentBizId,planBizId);
    }

}
