package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiAppointmentFileService;
import com.yd.csf.feign.client.appointmentfile.ApiAppointmentFileFeignClient;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileAddRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileEditRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFilePageRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentImportExcelRequest;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentExportExcelResponse;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentFilePageResponse;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentImportExcelResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotBlank;

/**
 * 预约附件信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/appointmentFile")
@Validated
public class ApiAppointmentFileController implements ApiAppointmentFileFeignClient {

    @Autowired
    private ApiAppointmentFileService apiAppointmentFileService;

    /**
     * 预约附件信息分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiAppointmentFilePageResponse>> page(ApiAppointmentFilePageRequest request) {
        return apiAppointmentFileService.page(request);
    }

    /**
     * 新增预约附件信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiAppointmentFileAddRequest request) {
        return apiAppointmentFileService.add(request);
    }

    /**
     * 编辑预约附件信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiAppointmentFileEditRequest request) {
        return apiAppointmentFileService.edit(request);
    }

    /**
     * 删除预约附件
     * @param appointmentFileBizId
     * @return
     */
    @Override
    public Result del(String appointmentFileBizId) {
        return apiAppointmentFileService.del(appointmentFileBizId);
    }

    /**
     * 下载预约附件
     * @param appointmentFileBizId
     * @return
     */
    @Override
    public Result download(String appointmentFileBizId) {
        return apiAppointmentFileService.download(appointmentFileBizId);
    }

    /**
     * 生成行程单PDF
     * @param appointmentBizId
     * @return
     */
    @Override
    public Result<String> itineraryPdf(String appointmentBizId) {
        return apiAppointmentFileService.itineraryPdf(appointmentBizId);
    }

    /**
     * Excel导出-预约信息
     * @param appointmentBizId
     * @return
     */
    @Override
    public Result<ApiAppointmentExportExcelResponse> appointmentExportExcel(String appointmentBizId) {
        return apiAppointmentFileService.appointmentExportExcel(appointmentBizId);
    }

    /**
     * Excel导入-预约信息
     * @return
     */
    @Override
    public Result<ApiAppointmentImportExcelResponse> appointmentImportExcel(MultipartFile file,ApiAppointmentImportExcelRequest request) {
        return apiAppointmentFileService.appointmentImportExcel(file, request);
    }


}
