package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.AppointmentReferrerLog;
import com.yd.csf.service.dao.AppointmentReferrerLogMapper;
import com.yd.csf.service.service.IAppointmentReferrerLogService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 预约-转介人信息日志表（快照表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Service
public class AppointmentReferrerLogServiceImpl extends ServiceImpl<AppointmentReferrerLogMapper, AppointmentReferrerLog> implements IAppointmentReferrerLogService {

    @Override
    public List<AppointmentReferrerLog> queryList(String appointmentLogBizId) {
        return this.baseMapper.selectList(new LambdaQueryWrapper<AppointmentReferrerLog>()
                .eq(AppointmentReferrerLog::getAppointmentLogBizId,appointmentLogBizId));
    }
}
