package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 受益人信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-18
 */
@Getter
@Setter
@TableName("beneficiary")
public class Beneficiary implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 受益人信息表唯一业务ID
     */
    @TableField("beneficiary_biz_id")
    private String beneficiaryBizId;

    /**
     * 与受保人关系（字典）
     */
    @TableField("insurant_rel")
    private String insurantRel;

    /**
     * 姓名-中文
     */
    @TableField("name_cn")
    private String nameCn;

    /**
     * 姓名-（拼音/英文，通过中文自动加载全部大写的拼音）
     */
    @TableField("name_py_en")
    private String namePyEn;

    /**
     * 证件类型（字典，下拉选择）
     */
    @TableField("document_type")
    private String documentType;

    /**
     * 证件号码
     */
    @TableField("id_number")
    private String idNumber;

    /**
     * 性别（字典，如果是身份证，自动获取性别和生日）
     */
    @TableField("gender")
    private String gender;

    /**
     * 出生日期（生日，如果是身份证，自动获取性别和生日）
     */
    @TableField("birthday")
    private LocalDateTime birthday;

    /**
     * 国籍（下拉选择）
     */
    @TableField("nationality")
    private String nationality;

    /**
     * 受益比例
     */
    @TableField("benefit_ratio")
    private BigDecimal benefitRatio;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
