package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保单批次保单关联表 - 存储批次与保单的关联关系，记录批次中每个保单的计算状态
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("batch_policy")
public class BatchPolicy implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 发佣批次表唯一业务ID
     */
    @TableField("batch_biz_id")
    private String batchBizId;

    /**
     * 保单表唯一业务ID
     */
    @TableField("policy_biz_id")
    private String policyBizId;

    /**
     * 保单FYC，记录该保单在批次中的FYC金额
     */
    @TableField("policy_fyc")
    private BigDecimal policyFyc;

    /**
     * 计算状态：PENDING-待计算, PROCESSING-计算中, CALCULATED-已计算, ERROR-计算错误
     */
    @TableField("calc_status")
    private String calcStatus;

    /**
     * 错误信息，当计算状态为ERROR时记录错误详情
     */
    @TableField("error_message")
    private String errorMessage;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
