package com.yd.csf.service.dto;

import com.yd.csf.feign.dto.appointment.ApiProductPlanAdditionalInfoDto;
import com.yd.csf.feign.dto.appointment.ApiProductPlanMainInfoDto;
import com.yd.csf.service.model.Policy;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class PolicyUpdateRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 新单跟进业务ID
     */
    @Schema(description = "新单跟进业务ID")
    private String policyBizId;

    /**
     * 产品计划(保单信息)
     */
    @Schema(description = "产品计划(保单信息)")
    private ApiProductPlanMainInfoDto apiProductPlanMainInfoDto;

    /**
     * 保单附加险列表
     */
    @Schema(description = "保单附加险列表")
    private List<ApiProductPlanAdditionalInfoDto> apiProductPlanAdditionalInfoDtoList;
}
