package com.yd.csf.feign.dto.taxation;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApiObjectTaxationDto {

    /**
     * 对象类型
     */
    private String objectType;

    /**
     * 对象所属表名（投保人表、受保人表等）
     */
    private String objectTableName;

    /**
     * 对象名
     */
    private String objectName;

    /**
     * 对象业务ID
     */
    private String objectBizId;

    /**
     * 税务列表信息
     */
    private List<ApiTaxationDto> apiTaxationDtoList;
}
