package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiCommissionSqlTemplateService;
import com.yd.csf.feign.client.commissionsqltemplate.ApiCommissionSqlTemplateFeignClient;
import com.yd.csf.feign.request.commissionsqltemplate.ApiCommissionSqlTemplatePageRequest;
import com.yd.csf.feign.response.commissionsqltemplate.ApiCommissionSqlTemplatePageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * SQL模板信息
 *
 * @author zxm
 * @since 2025-10-15
 */
@RestController
@RequestMapping("/commissionSqlTemplate")
@Validated
public class ApiCommissionSqlTemplateController implements ApiCommissionSqlTemplateFeignClient {

    @Autowired
    private ApiCommissionSqlTemplateService apiCommissionSqlTemplateService;

    /**
     * 分页查询-SQL模板信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiCommissionSqlTemplatePageResponse>> page(ApiCommissionSqlTemplatePageRequest request) {
        return apiCommissionSqlTemplateService.page(request);
    }
}
