package com.yd.csf.feign.dto.excel;

import com.yd.common.utils.DateUtil;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Data
public class ApiExcelAdditionalDto {

    //============以下是表字段============
    /**
     * 保险附加产品名称（中台保险附加产品名称，冗余）
     */
    private String productName;

    /**
     * 保费
     */
    private BigDecimal premium;


    //============以下是excel显示的字段，同上============
    /**
     * 保险附加产品名称（中台保险附加产品名称，冗余）
     */
    private String addProductName;

    /**
     * 保费
     */
    private BigDecimal addPremium;

    /**
     * 重新赋值ApiExcelAdditionalDto
     * @param list
     * @return
     */
    public static List<ApiExcelAdditionalDto> setApiExcelAdditionalDtoList(List<ApiExcelAdditionalDto> list) {
        List<ApiExcelAdditionalDto> newList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            newList = list.stream().map(dto -> {
                ApiExcelAdditionalDto additionalDto = new ApiExcelAdditionalDto();
                BeanUtils.copyProperties(dto,additionalDto);
                additionalDto.setAddPremium(dto.getPremium());
                additionalDto.setAddProductName(dto.getAddProductName());
                return additionalDto;
            }).collect(Collectors.toList());
        }
        return newList;
    }
}
