package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.enums.PolicyFollowStatusEnum;
import com.yd.csf.service.model.PolicyFollow;
import com.yd.csf.service.vo.PolicyFollowDetailVO;
import com.yd.csf.service.vo.PolicyFollowVO;

import java.util.List;
import java.util.Map;

/**
* @author Zhang Jianan
* @description 针对表【policy_follow(新单跟进表)】的数据库操作Service
* @createDate 2025-09-16 18:18:06
*/
public interface PolicyFollowService extends IService<PolicyFollow> {

    PolicyFollow getByPolicyBizId(String policyBizId);

    QueryWrapper<PolicyFollow> getQueryWrapper(PolicyFollowQueryRequest policyFollowQueryRequest);

    Page<PolicyFollowVO> getPolicyFollowVOPage(Page<PolicyFollow> policyFollowPage);

    Boolean updatePolicyFollow(PolicyFollowUpdateRequest policyFollowUpdateRequest);

    /**
     * 使用统一DTO更新新单跟进
     */
    Boolean updatePolicyFollowDto(PolicyFollowDto policyFollowDto);

    PolicyFollowVO getPolicyFollowVO(PolicyFollow policyFollow);

    Map<String, Object> addPolicyFollow(PolicyFollowAddRequest policyFollowAddRequest);

    /**
     * 使用统一DTO新增新单跟进
     */
    Map<String, Object> addPolicyFollowDto(PolicyFollowDto policyFollowDto);

    /**
     * 获取新单跟进详情（包含附加险和介绍人）
     */
    PolicyFollowDetailVO getPolicyFollowDetailVO(String policyBizId);

    Boolean addToPolicy(List<String> policyNoList);

    Boolean changePolicyFollowStatus(ChangePolicyFollowStatusRequest changePolicyFollowStatusRequest, PolicyFollow policyFollow);

    Boolean uploadAttachment(AttachmentUploadRequest attachmentUploadRequest);

    String getNextStatus(PolicyFollowStatusEnum policyFollowStatusEnum);

    String getCurrencyValue(String currency);

    PolicyReportData queryPolicyReportData(String policyBizId);

    PolicyFollow queryOneByPolicyNo(String policyNo);

    /**
     * 保存首期缴费信息
     */
    Boolean saveInitialPayment(InitialPaymentSaveRequest initialPaymentSaveRequest);

    /**
     * 保存邮寄信息
     */
    Boolean saveMailingInfo(MailingInfoSaveRequest mailingInfoSaveRequest);

    /**
     * 批量保存介绍人信息
     */
    Boolean batchSaveBrokers(BrokerBatchSaveRequest brokerBatchSaveRequest);
}
