package com.yd.csf.service.dto;

import com.yd.csf.service.vo.AddressVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 创建customer请求
 *
 */
@Data
public class CustomerAddRequest implements Serializable {

    /**
     * 自定义代码
     */
//    private String customCode;

    /**
     * 姓氏
     */
    @Schema(description = "姓氏")
    private String lastName;

    /**
     * 名字
     */
    @Schema(description = "名字")
    private String firstName;

    /**
     * 姓名
     */
    @Schema(description = "姓名")
    private String name;

    /**
     * 姓氏拼音
     */
    @Schema(description = "姓氏拼音")
    private String lastNamePinyin;

    /**
     * 名字拼音
     */
    @Schema(description = "名字-英文", requiredMode = Schema.RequiredMode.REQUIRED)
    private String firstNamePinyin;

    /**
     * 拼音全称
     */
    @Schema(description = "姓名拼音")
    private String pinyin;

    /**
     * 称谓
     */
    @Schema(description = "称谓 字典值: csf_customer_title", requiredMode = Schema.RequiredMode.REQUIRED)
    private String title;

    /**
     * 性别
     */
    @Schema(description = "性别 字典值: sys_gender")
    private Object gender;

    /**
     * 生日
     */
    @Schema(description = "生日")
    private Date birthday;

    /**
     * 出生日期
     */
    @Schema(description = "客户出生日期")
    private Date birthdate;

    /**
     * 异常信息
     */
    @Schema(description = "客户异常信息")
    private String abnormal;

    /**
     * 年龄
     */
    @Schema(description = "年龄", requiredMode = Schema.RequiredMode.REQUIRED)
    private String age;

    /**
     * 地区代码
     */
    @Schema(description = "地区代码")
    private String areaCode;

    /**
     * 电话号码
     */
    @Schema(description = "电话号码", requiredMode = Schema.RequiredMode.REQUIRED)
    private String phone;

    /**
     * 电子邮箱
     */
    @Schema(description = "电子邮箱", requiredMode = Schema.RequiredMode.REQUIRED)
    private String email;

    /**
     * 是否吸烟
     */
    @Schema(description = "是否吸烟 字典值: sys_no_yes")
    private String smoke;

    /**
     * 吸烟数量
     */
    @Schema(description = "吸烟数量")
    private String smokeQuantity;

    /**
     * 行业
     */
    @Schema(description = "行业", requiredMode = Schema.RequiredMode.REQUIRED)
    private String companyType;

    /**
     * 固定电话
     */
    @Schema(description = "固定电话")
    private String fixedPhone;

    /**
     * 来源
     */
    @Schema(description = "客户来源")
    private String source;

    /**
     * 证件类型
     */
    @Schema(description = "证件类型 字典值: csf_id_type")
    private String idType;

    /**
     * 证件号码
     */
    @Schema(description = "证件号码")
    private String idCard;

     /**
     * 身份证地址
     */
    @Schema(description = "身份证地址")
    private String idCardAddress;

    /**
     * 护照号
     */
    @Schema(description = "护照号")
    private String passport;

    /**
     * 往来港澳通行证号码
     */
    @Schema(description = "往来港澳通行证号码")
    private String eepCode;

    /**
     * 婚姻状况
     */
    @Schema(description = "婚姻状况 字典值: csf_marriage", requiredMode = Schema.RequiredMode.REQUIRED)
    private Object marriage;

    /**
     * 出生地
     */
    @Schema(description = "出生地")
    private String birthplace;

    /**
     * 教育程度
     */
    @Schema(description = "教育程度 字典值: csf_education", requiredMode = Schema.RequiredMode.REQUIRED)
    private Object education;

    /**
     * 国籍 (国家/地区)
     */
    @Schema(description = "国籍 (国家/地区)", requiredMode = Schema.RequiredMode.REQUIRED)
    private String country;

    /**
     * 国籍 (国家/地区) 名称
     */
    @Schema(description = "国籍 (国家/地区) 名称")
    private String countryName;

    // region 客户扩展信息

    /**
     * 客户类型
     */
    @Schema(description = "客户类型 字典值: csf_customer_type")
    private Object customerType;

    /**
     * 居住地区代码
     */
    @Schema(description = "居住地区代码")
    private String residenceAreaCode;

    /**
     * 住宅电话
     */
    @Schema(description = "住宅电话")
    private String residenceTelephone;

    /**
     * 是否长期出国
     */
    @Schema(description = "是否长期出国 字典值: sys_no_yes")
    private String longtimeAbroad;

    /**
     * 地址
     */
    @Schema(description = "地址列表")
    private List<AddressVO> addressList;

    /**
     * 居住地址
     */
//    private AddressVO residenceAddress;
//
//    /**
//     * 住宅地址
//     */
//    private AddressVO residentialAddress;
//
//    /**
//     * 邮寄地址
//     */
//    private AddressVO mailingAddress;
//
//    /**
//     * 公司地址
//     */
//    private AddressVO companyAddress;

    /**
     * 公司名称
     */
    @Schema(description = "公司名称")
    private String companyName;

    /**
     * 公司地区代码
     */
    @Schema(description = "公司地区代码")
    private String companyAreaCode;

    /**
     * 公司地址邮政编码
     */
    @Schema(description = "公司地址邮政编码")
    private String companyAddressPostcode;

    /**
     * 公司电话
     */
    @Schema(description = "公司电话")
    private String companyTelephone;

    /**
     * 职位
     */
    @Schema(description = "职位")
    private String position;

    /**
     * 工作年限
     */
    @Schema(description = "工作年限")
    private String workYear;

    /**
     * 薪资
     */
    @Schema(description = "薪资")
    private BigDecimal salary;

    // endregion

    private static final long serialVersionUID = 1L;
}