package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.AppointmentReferrer;
import com.yd.csf.service.dao.AppointmentReferrerMapper;
import com.yd.csf.service.service.IAppointmentReferrerService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 预约-转介人信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Service
public class AppointmentReferrerServiceImpl extends ServiceImpl<AppointmentReferrerMapper, AppointmentReferrer> implements IAppointmentReferrerService {

    @Override
    public Boolean delByAppointmentBizId(String appointmentBizId) {
        return this.remove(new LambdaQueryWrapper<AppointmentReferrer>().eq(AppointmentReferrer::getAppointmentBizId,appointmentBizId));
    }

    @Override
    public List<AppointmentReferrer> queryList(String appointmentBizId) {
        return baseMapper.selectList(new LambdaQueryWrapper<AppointmentReferrer>()
                .eq(AppointmentReferrer::getAppointmentBizId,appointmentBizId));
    }
}
