package com.yd.csf.feign.dto.variable;

import lombok.Data;
import java.math.BigDecimal;

@Data
public class ApiRuleConditionConfigDto {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 条件配置唯一业务ID
     */
    private String conditionBizId;

    /**
     * 类型（1-条件 2-计算公式）
     */
    private String type;

    /**
     * 一级分类编码
     */
    private String firstCategoryCode;

    /**
     * 一级分类名称
     */
    private String firstCategoryName;

    /**
     * 二级分类编码
     */
    private String secondCategoryCode;

    /**
     * 二级分类名称
     */
    private String secondCategoryName;

    /**
     * 计算公式
     */
    private String calculationFormula;

    /**
     * 条件值（范围内的值）
     */
    private String conditionalValue;

    /**
     * 条件-最小值（在范围条件中表示最小值）
     */
    private BigDecimal minValue;

    /**
     * 条件-最大值（在范围条件中表示最大值）
     */
    private BigDecimal maxValue;

    /**
     * 条件-是否包含最小值（是否包含最小值，1表示包含，0表示不包含）
     */
    private Integer includeMin;

    /**
     * 条件-是否包含最大值（是否包含最大值，1表示包含，0表示不包含）
     */
    private Integer includeMax;

    /**
     * 优先级（数字越小优先级越高）
     */
    private Integer priority;
}
