package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 查询fortune请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FortuneQueryRequest extends PageDto implements Serializable {
    /**
     * 出账状态
     */
    @Schema(description = "出账状态 0=待出账 1=可出帐 2=完成出账 3=部分出账 4=保留 5=已失效, 字典值: csf_fortune_status")
    private String status;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    private static final long serialVersionUID = 1L;
}