package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionUpdateRequest implements Serializable {
    /**
     * 保单来佣业务id
     */
    @Schema(description = "保单来佣业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String commissionBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

     /**
     * 保费
     */
    @Schema(description = "保费")
    private String premium;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

     /**
     * 来佣比对状态
     */
    @Schema(description = "来佣比对状态 1=比对成功 2=比对失败")
    private String status;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    @Schema(description = "总来佣期数")
    private Integer totalPeriod;

    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionType;

    /**
     * 来佣金额
     */
    @Schema(description = "来佣金额")
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    @Schema(description = "来佣币种")
    private String currency;

     /**
      * 结算汇率
      */
    @Schema(description = "结算汇率")
    private String exchangeRate;

    /**
     * 来佣日期
     */
    @Schema(description = "来佣日期 格式: yyyy-MM-dd")
    private String commissionDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
