package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * fna表单表
 * @TableName fna_form
 */
@TableName(value ="fna_form")
@Data
public class FnaForm implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * fna唯一业务ID
     */
    private String fnaFormBizId;

    /**
     * 系统用户唯一业务ID
     */
    private String userBizId;

    /**
     * 理财顾问资料业务ID（查询个人资料）
     */
    private String agentBizId;

    /**
     * 客户唯一业务ID
     */
    private String customerBizId;

    /**
     * 个人资料
     */
    private Object personalData;

    /**
     * 家庭状况
     */
    private Object familyMembers;

    /**
     * 保单持有人个人已有保障
     */
    private Object existingSecurityOwner;

    /**
     * 受保人个人已有保障
     */
    private Object existingSecurityInsured;

    /**
     * 收支情况
     */
    private Object incomeExpense;

    /**
     * 流动资产
     */
    private Object liquidAssets;

    /**
     * 自住用途之房地產
     */
    private Object primaryResidence;

    /**
     * 投資房地產
     */
    private Object investment;

    /**
     * 公司业务资料
     */
    private Object companyBusinessData;

    /**
     * 表单其他问题
     */
    private Object other;

    /**
     * 表单状态 0-未完成 1-已完成
     */
    private String fnaFormStatus;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}