package com.yd.csf.service.enums;

/**
 * 出账状态枚举 0=待出账 1=可出帐，待检核 2=完成出账 3=部分出账 4=保留 5=已失效 6=可出帐，检核完成 7=未找到当前预计发佣对应的来佣
 */
public enum FortuneStatusEnum {

    //出账状态枚举
    WAIT("待出账", "0"),
    CAN_SEND("可出账, 待检核", "1"),
    SENT("完成出账", "2"),
    PARTIAL_SENT("部分出账", "3"),
    RESERVED("保留", "4"),
    INVALID("已失效", "5"),
    CHECKED("可出账, 已检核", "6"),
    MATCH_FAIL("未找到当前预计发佣对应的来佣", "7"),
    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    FortuneStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
