package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiBasicLawCalculateService;
import com.yd.csf.feign.client.basiclawcalculate.ApiBasicLawCalculateFeignClient;
import com.yd.csf.feign.request.basiclawcalculate.ApiGenerateBillingRequest;
import com.yd.csf.feign.response.basiclawcalculate.ApiGenerateBillingResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 基本法计算接口
 *
 * @author zxm
 * @since 2025-10-21
 */
@RestController
@RequestMapping("/basicLaw/calculate")
@Validated
public class ApiBasicLawCalculateController implements ApiBasicLawCalculateFeignClient {

    @Autowired
    private ApiBasicLawCalculateService apiBasicLawCalculateService;

    /**
     * 生成出账
     * @param request
     * @return
     */
    @Override
    public Result<ApiGenerateBillingResponse> generateBilling(ApiGenerateBillingRequest request) {
        return apiBasicLawCalculateService.generateBilling(request);
    }
}
