package com.yd.csf.feign.client.agentreferralrelation;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.agentreferralrelation.ApiAgentReferralRelationFeignFallbackFactory;
import com.yd.csf.feign.request.agentreferralrelation.ApiAgentReferralRelationSaveRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 香港保险服务-推荐关系信息Feign客户端
 */
@FeignClient(name = "yd-csf-api",path = "/csf/api/agentReferralRelation",fallbackFactory = ApiAgentReferralRelationFeignFallbackFactory.class)
public interface ApiAgentReferralRelationFeignClient {

    /**
     * 保存-推荐关系信息
     * @param request
     * @return
     */
    @PostMapping("/save")
    Result save(@Validated @RequestBody ApiAgentReferralRelationSaveRequest request);
}
