package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.constant.RedisConstants;
import com.yd.common.result.Result;
import com.yd.common.utils.RedisUtil;
import com.yd.csf.api.service.ApiExpectedFortuneService;
import com.yd.csf.feign.client.expectedfortune.ApiExpectedFortuneFeignClient;
import com.yd.csf.feign.request.expectedfortune.ApiGenerateExpectedFortuneRequest;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.feign.response.expectedfortune.ApiGenerateExpectedFortuneResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 预计发佣信息
 *
 * @author zxm
 * @since 2025-11-17
 */
@RestController
@RequestMapping("/expectedFortune")
@Validated
public class ApiExpectedFortuneController implements ApiExpectedFortuneFeignClient {

    @Autowired
    private ApiExpectedFortuneService apiExpectedFortuneService;

    @Autowired
    private RedisUtil redisUtil;

    /**
     * 生成预计发佣
     * @param request
     * @return
     */
    @Override
    public Result<ApiGenerateExpectedFortuneResponse> generate(ApiGenerateExpectedFortuneRequest request) {
        try {
            return apiExpectedFortuneService.generate(request);
        }catch (Exception e) {
            //抛出异常，销毁redis缓存
            redisUtil.deleteObject(RedisConstants.EXPECTED_FORTUNE + request.getPolicyNo());
            return Result.fail(e.getMessage());
        }
    }

    /**
     * 分页查询 - 预计发佣
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedFortunePageResponse>> page(ApiExpectedFortunePageRequest request) {
        return apiExpectedFortuneService.page(request);
    }

    /**
     * 查询保单是否生成过预计发佣
     * @param policyNo
     * @return
     */
    @Override
    public Result<Boolean> isGenerate(String policyNo) {
        return apiExpectedFortuneService.isGenerate(policyNo);
    }
}
