package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * 新单跟进表
 *
 * @TableName policy_follow
 */
@TableName(value = "policy_follow")
@Data
public class PolicyFollow implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * FNA 业务ID
     */
    private String fnaBizId;

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 客户业务id
     */
    private String customerBizId;

    /**
     * 递交日期
     */
    private Date submitDate;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 签单日期
     */
    private Date signDate;

    /**
     * 签单人
     */
    private String signer;

    /**
     * 签单人业务id
     */
    private String signerBizId;

    /**
     * 签单人执业编号
     */
    private String practiceCode;

    /**
     * 签单地点
     */
    private String signLocation;

    /**
     * 缮发日期
     */
    private Date issueDate;

    /**
     * 冷静期结束日期
     */
    private Date coolingOffEndDate;

    /**
     * 冷静期天数
     */
    private Integer coolingOffDays;

    /**
     * 核保日期
     */
    private Date underwritingDate;

    /**
     * 生效日期
     */
    private Date effectiveDate;

    /**
     * 续保日期
     */
    private Date renewalDate;

    /**
     * 保单回执日期
     */
    private Date receiptDate;

    /**
     * 回执状态
     */
    private String receiptStatus;

    /**
     * 是否开通直接支付
     */
    private Integer directPaymentEnabled;

    /**
     * 供款年期
     */
    private Integer issueNumber;

    /**
     * 保障期限
     */
    private Integer guaranteePeriod;

    /**
     * 保额（重疾险）
     */
    private BigDecimal sumInsured;

    /**
     * 付款频率（字典）
     */
    private String paymentFrequency;

    /**
     * 每期保费
     */
    private BigDecimal eachIssuePremium;

    /**
     * 是否预缴: 0-否, 1-是
     */
    private Integer isPrepay;

    /**
     * 是否追溯: 0-否, 1-是
     */
    private Integer isTraceable;

    /**
     * 回溯日期
     */
    private Date retroactiveDate;

    /**
     * 预缴年期
     */
    private Integer prepaidTerm;

    /**
     * 预付额
     */
    private String prepaidAmount;

    /**
     * 折扣后预付额
     */
    private String prepaidAmountAfterDiscount;

    /**
     * 保单截止日期
     */
    private Date policyExpirationDate;

    /**
     * 缴费编号
     */
    private String paymentNumber;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品险种
     */
    private String productCate;

    /**
     * 产品险种业务 id
     */
    private String insuranceCategoryBizId;

    /**
     * 保险公司
     */
    private String insuranceCompany;

    /**
     * 保险公司业务id
     */
    private String insuranceCompanyBizId;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    private String reconciliationCompanyBizId;

    /**
     * 新单跟进状态
     */
    private String status;

    /**
     * 下一步跟进状态列表
     */
    private String nextStatusList;

    /**
     * 保單持有人
     */
    private String policyHolder;

    /**
     * 受保人
     */
    private String insured;

    /**
     * 受保人年龄
     */
    private Integer insuredAge;

    /**
     * 宽限期
     */
    private Integer gracePeriod;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    private Integer isJoin;

    /**
     * 保单币种
     */
    private String policyCurrency;

    /**
     * 首期付款方式（字典）
     */
    private String initialPaymentMethod;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    private BigDecimal initialPremium;

    /**
     * 首期已缴保费
     */
    private BigDecimal initialPremiumPaid;

    /**
     * 首期待缴保费
     */
    private BigDecimal initialPremiumDue;

    /**
     * 首期缴费总额
     */
    private BigDecimal initialPremiumTotal;

    /**
     * 首期缴费状态
     */
    private String initialPaymentStatus;

    /**
     * 首期保费优惠金额
     */
    private BigDecimal initialPremiumDiscount;

    /**
     * 寄送方式 字典值：1-自提 2-快递
     */
    private String mailingMethod;

    /**
     * 续期付款方式（字典）
     */
    private String renewalPaymentMethod;

    /**
     * 红利方式（字典）
     */
    private String dividendDistributionMethod;

    /**
     * 快递单号
     */
    private String deliveryNo;

    /**
     * 保单征费
     */
    private String policyLevy;

    /**
     * 最晚缴费日期
     */
    private Date latestPaymentDate;

    /**
     * 经纪公司签收日期
     */
    private Date brokerSignDate;

    /**
     * 保险公司寄出日期
     */
    private Date insurerMailingDate;

    /**
     * 客户签收日期
     */
    private Date customerSignDate;

    /**
     * 附件地址列表 逗号隔开
     */
    private String attachments;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}