package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 更新Fna表单请求
 */
@Data
public class FnaFormUpdateRequest implements Serializable {
    /**
     * 保存方式 temp-暂存 save-保存
     */
    @Schema(description = "保存方式 temp-暂存 save-保存", requiredMode = Schema.RequiredMode.REQUIRED)
    private String saveType;

    /**
     * Fna表单唯一业务ID
     */
    @Schema(description = "Fna表单唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fnaFormBizId;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * 介绍人列表
     */
    @Schema(description = "介绍人列表")
    private List<BrokerData> brokerList;

    /**
     * 受供养人列表
     */
    @Schema(description = "受供养人列表")
    private List<DependantData> dependantList;

    /**
     * 保单持有人个人已有保障
     */
    private List<ExistingSecurity> existingSecurityOwner;

    /**
     * 不动产信息
     */
    @Schema(description = "不动产信息")
    private List<OwnerProperties> primaryResidence;

    /**
     * 保费负担能力评估
     */
    @Schema(description = "保费负担能力评估")
    private PremiumAffordability premiumAffordability;

    /**
     * 公司业务资料
     */
    @Schema(description = "公司业务资料")
    private CompanyBusinessData companyBusinessData;

    private static final long serialVersionUID = 1L;
}