package com.yd.csf.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * SQL模板条件入参参数及参数值对象（通用，用于各种SQL模板计算值入参条件参数值，这边集成大部分SQL模所需的条件参数，SQL模板会去匹配入参sqlTemplateParamDto有符合的就作为条件参数）
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SqlTemplateParamDto {

    /**
     * 条件类型表唯一业务ID
     */
    private String conditionTypeBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 产品代码
     */
    private String productCode;

    /**
     * 保单绑定转介人业务ID（销售业务员，客户端用户表唯一业务ID）
     */
    private String brokerBizId;
}
