package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiRuleItemConfigService;
import com.yd.csf.feign.client.ruleItemconfig.ApiRuleItemConfigFeignClient;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigAddRequest;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigEditRequest;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigPageRequest;
import com.yd.csf.feign.response.ruleItemconfig.ApiRuleItemConfigDetailResponse;
import com.yd.csf.feign.response.ruleItemconfig.ApiRuleItemConfigPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 基本法项目配置信息
 *
 * @author zxm
 * @since 2025-10-15
 */
@RestController
@RequestMapping("/ruleItemConfig")
@Validated
public class ApiRuleItemConfigController implements ApiRuleItemConfigFeignClient {

    @Autowired
    private ApiRuleItemConfigService apiRuleItemConfigService;

    /**
     * 分页查询-基本法项目配置信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRuleItemConfigPageResponse>> page(ApiRuleItemConfigPageRequest request) {
        return apiRuleItemConfigService.page(request);
    }

    /**
     * 详情-基本法项目配置信息
     * @param ruleItemBizId
     * @return
     */
    @Override
    public Result<ApiRuleItemConfigDetailResponse> detail(String ruleItemBizId) {
        return apiRuleItemConfigService.detail(ruleItemBizId);
    }

    /**
     * 添加-基本法项目配置信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiRuleItemConfigAddRequest request) {
        return apiRuleItemConfigService.add(request);
    }

    /**
     * 编辑-基本法项目配置信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiRuleItemConfigEditRequest request) {
        return apiRuleItemConfigService.edit(request);
    }

    /**
     * 删除-基本法项目配置信息 TODO
     * @param ruleItemBizId
     * @return
     */
    @Override
    public Result del(String ruleItemBizId) {
        return apiRuleItemConfigService.del(ruleItemBizId);
    }
}
