package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 业务员积分明细表 - 存储业务员的每次增加或者减少的FYC积分
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("agent_detail_fyc")
public class AgentDetailFyc implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 业务员ID（会员唯一业务ID）
     */
    @TableField("agent_id")
    private String agentId;

    /**
     * 积分来源类型：保单转介费、一级管理奖、二级管理奖、辅导津贴奖、终身推荐奖
     */
    @TableField("source_type")
    private String sourceType;

    /**
     * 积分提供保单表唯一业务ID
     */
    @TableField("policy_biz_id")
    private String policyBizId;

    /**
     * 积分提供者（会员唯一业务ID）
     */
    @TableField("provide_id")
    private String provideId;

    /**
     * 变化前的业务员总FYC积分
     */
    @TableField("before_fyc")
    private BigDecimal beforeFyc;

    /**
     * 变化后的业务员总FYC积分
     */
    @TableField("after_fyc")
    private BigDecimal afterFyc;

    /**
     * 变化值（-代表减少）
     */
    @TableField("change_fyc")
    private String changeFyc;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
