package com.yd.csf.feign.request.formulaconfig;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ApiFormulaConfigAddRequest {

    /**
     * 公式名称
     */
    @NotBlank(message = "公式名称不能为空")
    private String name;

    /**
     * 计算公式（变量中文名称组合，用于展示）
     */
    @NotBlank(message = "计算公式（变量中文名称组合，用于展示）不能为空")
    private String calculationFormulaCn;

    /**
     * 计算公式（变量表唯一业务ID组合）
     */
    @NotBlank(message = "计算公式（变量表唯一业务ID组合）不能为空")
    private String calculationFormulaBizId;

    /**
     * 变量表唯一业务ID列表
     */
    @NotEmpty(message = "变量表唯一业务ID列表不能为空")
    private List<String> variableBizIdList;

    /**
     * 描述
     */
    private String description;

    /**
     * 显示顺序
     */
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;
}
