package com.yd.csf.feign.dto.appointment;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 预约信息
 */
@Data
public class ApiAppointmentInfoDto {

    /**
     * 预约信息主表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String appointmentBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    @NotBlank(message = "签约信息-关联客户信息表唯一业务ID不能为空")
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @NotBlank(message = "签约信息-关联客户编号不能为空")
    private String customerNo;

    /**
     * 关联FNA信息表唯一业务ID（冗余字段）
     */
    @NotBlank(message = "签约信息-关联FNA信息表唯一业务ID不能为空")
    private String fnaBizId;

    /**
     * 关联FNA编号（和FNA信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @NotBlank(message = "签约信息-关联FNA编号不能为空")
    private String fnaNo;

    /**
     * 关联计划书信息表唯一业务ID（冗余字段）
     */
    private String proposalBizId;

    /**
     * 关联计划书编号（和计划书信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String proposalNo;

    /**
     * 申请类型（字典）
     */
    @NotBlank(message = "签约信息-申请类型不能为空")
    private String applyType;

    /**
     * 签单日
     */
    @NotNull(message = "签约信息-签单日不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime signDate;

    /**
     * 到港时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime arrivalTime;

    /**
     * 离港时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime departureTime;

    /**
     * 会面地点（字典）
     */
    private String meetingPoint;

    /**
     * 签单地址（签单地点）
     */
    private String signingAddress;

    /**
     * 客户在港期间联络电话区号
     */
    private String hkMobileCode;

    /**
     * 客户在港期间联络电话
     */
    private String hkMobile;

    /**
     * 是否开户: 0-否, 1-是（字典）
     */
    private Integer isOpenAccount;

    /**
     * 开户行名称
     */
    private String bankName;

    /**
     * 开户行支行（分行）
     */
    private String bankBranchName;

    /**
     * 开户时间段（开始）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime openAccountStartTime;

    /**
     * 开户时间段（结束）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime openAccountEndTime;

    /**
     * 开户地点
     */
    private String openAccountLocation;

    /**
     * 开户须知
     */
    private String openAccountNotice;

    /**
     * 开户所需资料
     */
    private String materials;

    /**
     * 是否体检: 0-否, 1-是（字典）
     */
    private Integer isTj;

    /**
     * 是否购买过香港保险: 0-否, 1-是（字典）
     */
    private Integer isBuy;

    /**
     * 转保声明选项: 0-否, 1-是 2-尚未決定（字典）
     */
    private String policyTransfer;

    /**
     * 是否有用车服务：0-否, 1-是（字典）
     */
    private Integer isUseCar;

    /**
     * 是否法定受益人
     */
    @NotBlank(message = "签约信息-是否法定受益人不能为空")
    private String isLegalBeneficiary;

    /**
     * 转介人是否陪同
     */
    private String isReferrerAccompany;

    /**
     * 创建人用户名
     */
    private String creatorName;

    /**
     * 陪同转介人信息列表
     */
    private List<ApiAppointmentReferrerDto> referrerDtoList;

    /**
     * 签单员信息列表
     */
    private List<ApiAppointmentUserSignDto> userSignDtoList;
}
