package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.formulaconfig.ApiFormulaConfigPageRequest;
import com.yd.csf.feign.response.formulaconfig.ApiFormulaConfigPageResponse;
import com.yd.csf.service.dto.FormulaConfigDto;
import com.yd.csf.service.model.FormulaConfig;
import com.yd.csf.service.dao.FormulaConfigMapper;
import com.yd.csf.service.model.RuleItemConfig;
import com.yd.csf.service.model.Variable;
import com.yd.csf.service.service.IFormulaConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 公式配置表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Service
public class FormulaConfigServiceImpl extends ServiceImpl<FormulaConfigMapper, FormulaConfig> implements IFormulaConfigService {

    @Override
    public IPage<ApiFormulaConfigPageResponse> page(Page<ApiFormulaConfigPageResponse> page,
                                                    ApiFormulaConfigPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<FormulaConfig> queryList(FormulaConfigDto dto) {
        List<FormulaConfig> list = baseMapper.selectList(new LambdaQueryWrapper<FormulaConfig>()
                .in(!CollectionUtils.isEmpty(dto.getFormulaBizIdList()),FormulaConfig::getFormulaBizId,dto.getFormulaBizIdList())
                .eq(StringUtils.isNotBlank(dto.getFormulaBizId()) && !dto.getIsExcludeMy(), FormulaConfig::getFormulaBizId,dto.getFormulaBizId())
                .eq(StringUtils.isNotBlank(dto.getName()),FormulaConfig::getName,dto.getName())
                .ne(dto.getIsExcludeMy(),FormulaConfig::getFormulaBizId,dto.getFormulaBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param formulaBizId
     * @return
     */
    @Override
    public FormulaConfig queryOne(String formulaBizId) {
        return this.getOne(new LambdaQueryWrapper<FormulaConfig>().eq(FormulaConfig::getFormulaBizId,formulaBizId));
    }

}
