package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 保单附加险信息表
 * @TableName policy_additional
 */
@TableName(value ="policy_additional")
@Data
public class PolicyAdditional implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 保单附加险信息表唯一业务ID
     */
    private String policyAdditionalBizId;

    /**
     * 新单跟进业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 产品计划信息表唯一业务ID
     */
    private String planBizId;

    /**
     * 保险附加产品唯一业务ID（中台保险附加产品业务id，冗余）
     */
    private String additionalProductBizId;

    /**
     * 保险附加产品名称（中台保险附加产品名称，冗余）
     */
    private String addProductName;

    /**
     * 货币（字典）
     */
    private String currency;

    /**
     * 保费
     */
    private BigDecimal premium;

    /**
     * 保额
     */
    private BigDecimal sumInsured;

    /**
     * 保障地区（字典）
     */
    private String guaranteeRegion;

    /**
     * 等级（字典）
     */
    private String level;

    /**
     * 自付额（字典）
     */
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    private String additionalSafeguards;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}