package com.yd.csf.service.utils;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

public class MyBatisPlusCodeGenerator {
    public static void main(String[] args) {
        FastAutoGenerator.create("jdbc:mysql://localhost:3306/yd-csf?serverTimezone=GMT%2B8", "root", "123456")
                .globalConfig(builder -> {
                    builder.author("zxm")
                            .outputDir("src/main/java/com/yd/csf/service");
//                            .outputDir("D:/soft/ideaproject/v2/yd-csf/yd-csf-service/src/main/java");
                })
                .packageConfig(builder -> {
                    builder.parent("com.yd.csf.service")
                            .entity("model")
                            .mapper("dao")
                            .service("service")
                            .serviceImpl("service.impl")
                            .xml("mappers");
                })
                .strategyConfig(builder -> {
                    builder.addInclude(
                            "appointment","beneficiary","insurant","policyholder"
//                            "additional", "appointment", "appointment_file",
//                            "beneficiary", "beneficiary_company", "beneficiary_individual",
//                            "insurant", "policyholder", "product_plan",
//                            "rel_tenant_project_appointment", "second_holder"

                    )
                            .entityBuilder()
                            .enableLombok()
                            .enableTableFieldAnnotation()
                            .controllerBuilder()
                            .enableRestStyle();
                })
                .templateEngine(new FreemarkerTemplateEngine())
                .execute();
    }
}

