package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.SecondHolder;
import com.yd.csf.service.dao.SecondHolderMapper;
import com.yd.csf.service.service.ISecondHolderService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 第二持有人信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class SecondHolderServiceImpl extends ServiceImpl<SecondHolderMapper, SecondHolder> implements ISecondHolderService {

    /**
     * 查询单个对象
     * @param secondHolderBizId
     * @return
     */
    @Override
    public SecondHolder queryOne(String secondHolderBizId) {
        return this.getOne(new LambdaQueryWrapper<SecondHolder>().eq(SecondHolder::getSecondHolderBizId,secondHolderBizId));
    }

    /**
     * 根据预约业务id和第二持有人业务id查询单个对象
     * @param appointmentBizId
     * @param secondHolderBizId
     * @return
     */
    @Override
    public SecondHolder queryOne(String appointmentBizId, String secondHolderBizId) {
        return this.getOne(new LambdaQueryWrapper<SecondHolder>()
                .eq(StringUtils.isNotBlank(appointmentBizId),SecondHolder::getAppointmentBizId,appointmentBizId)
                .eq(StringUtils.isNotBlank(secondHolderBizId),SecondHolder::getSecondHolderBizId,secondHolderBizId)
        );
    }

}
