package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.auth.core.utils.SecurityUtil;
import com.yd.common.enums.CommonEnum;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.dto.FortuneAccountExportDTO;
import com.yd.csf.service.dto.FortuneAccountQueryRequest;
import com.yd.csf.service.enums.FortuneAccountStatusEnum;
import com.yd.csf.service.model.FortuneAccount;
import com.yd.csf.service.service.FortuneAccountService;
import com.yd.csf.service.dao.FortuneAccountMapper;
import com.yd.csf.service.vo.FortuneAccountVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
* @author Zhang Jianan
* @description 针对表【fortune_account(出账记录表)】的数据库操作Service实现
* @createDate 2025-09-23 15:45:32
*/
@Service
public class FortuneAccountServiceImpl extends ServiceImpl<FortuneAccountMapper, FortuneAccount>
    implements FortuneAccountService{

    private final Gson GSON = new Gson();

    @Override
    public QueryWrapper<FortuneAccount> getQueryWrapper(FortuneAccountQueryRequest fortuneAccountQueryRequest) {
        QueryWrapper<FortuneAccount> queryWrapper = new QueryWrapper<>();
        if (fortuneAccountQueryRequest == null) {
            return queryWrapper;
        }
        queryWrapper.eq(StringUtils.isNotBlank(fortuneAccountQueryRequest.getBroker()), "broker", fortuneAccountQueryRequest.getBroker());
        queryWrapper.eq(StringUtils.isNotBlank(fortuneAccountQueryRequest.getTeam()), "team", fortuneAccountQueryRequest.getTeam());
        queryWrapper.eq(StringUtils.isNotBlank(fortuneAccountQueryRequest.getStatus()), "status", fortuneAccountQueryRequest.getStatus());
        queryWrapper.ge(fortuneAccountQueryRequest.getAccountDateStart() != null, "fortune_account_date", fortuneAccountQueryRequest.getAccountDateStart());
        queryWrapper.le(fortuneAccountQueryRequest.getAccountDateEnd() != null, "fortune_account_date", fortuneAccountQueryRequest.getAccountDateEnd());

        // 默认排序
        queryWrapper.orderByDesc("fortune_account_date");
        return queryWrapper;
    }

    @Override
    public Page<FortuneAccountVO> getFortuneAccountVOPage(Page<FortuneAccount> fortunePage) {
        List<FortuneAccount> fortuneAccountList = fortunePage.getRecords();
        Page<FortuneAccountVO> fortuneAccountVOPage = new Page<>(fortunePage.getCurrent(), fortunePage.getSize(), fortunePage.getTotal());

        if (CollectionUtils.isEmpty(fortuneAccountList)) {
            return fortuneAccountVOPage;
        }

        List<FortuneAccountVO> fortuneAccountVOList = new ArrayList<>();
        for (FortuneAccount fortuneAccount : fortuneAccountList) {
            FortuneAccountVO fortuneAccountVO = FortuneAccountVO.objToVo(fortuneAccount);
            fortuneAccountVO.setFortuneList(GSON.fromJson(fortuneAccount.getContent(), new TypeToken<List<Map<String, Object>>>(){}.getType()));
            fortuneAccountVOList.add(fortuneAccountVO);
        }

        fortuneAccountVOPage.setRecords(fortuneAccountVOList);
        return fortuneAccountVOPage;
    }

    @Override
    public void saveFortuneAccount(List<FortuneAccountExportDTO> accountExportDTOList) {
        if (CollectionUtils.isEmpty(accountExportDTOList)) {
            return;
        }
        // 当前登录用户
        AuthUserDto currentLoginUser = SecurityUtil.getCurrentLoginUser();
        Long loginUserId = currentLoginUser.getId();

        List<FortuneAccount> fortuneAccountList = new ArrayList<>();
        Date currentDate = new Date();
        for (FortuneAccountExportDTO accountExportDTO : accountExportDTOList) {
            FortuneAccount fortuneAccount = new FortuneAccount();
            fortuneAccount.setFortuneAccountBizId(RandomStringGenerator.generateBizId16("fortune_account"));
            fortuneAccount.setBroker(accountExportDTO.getBroker());
            fortuneAccount.setTeam(accountExportDTO.getTeam());
            fortuneAccount.setCurrency(accountExportDTO.getCurrency());
            fortuneAccount.setAmount(accountExportDTO.getAmount());
            fortuneAccount.setFortuneAccountDate(currentDate);
            // 出账状态默认待出账
            fortuneAccount.setStatus(FortuneAccountStatusEnum.CANSEND.getItemValue());

            // 转换为List<Map<String, Object>>
            Map<String, BigDecimal> fortuneAmounts = accountExportDTO.getFortuneAmounts();
            List<Map<String, Object>> fortuneList = new ArrayList<>();
            for (Map.Entry<String, BigDecimal> entry : fortuneAmounts.entrySet()) {
                Map<String, Object> fortune = new HashMap<>();
                fortune.put("fortuneName", entry.getKey());
                fortune.put("amount", entry.getValue());
                fortuneList.add(fortune);
            }
            fortuneAccount.setContent(GSON.toJson(fortuneList));
            fortuneAccount.setCreatorId(loginUserId.toString());
            fortuneAccount.setUpdaterId(loginUserId.toString());
            fortuneAccount.setCreateTime(currentDate);
            fortuneAccount.setUpdateTime(currentDate);

            fortuneAccountList.add(fortuneAccount);
        }

        this.saveBatch(fortuneAccountList);
    }
}




