package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.yd.csf.service.vo.AddressVO;
import lombok.Data;

/**
 * CSF客户信息扩展表
 * @TableName customer_expand
 */
@TableName(value ="customer_expand")
@Data
public class CustomerExpand implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 客户扩展唯一业务ID
     */
    private String customerExpandBizId;

    /**
     * 客户信息唯一标识(业务ID)
     */
    private String customerBizId;

    /**
     * 客户类型
     */
    private String customerType;

    /**
     * 居住地区代码
     */
    private String residenceAreaCode;

    /**
     * 住宅电话
     */
    private String residenceTelephone;

    /**
     * 是否长期出国
     */
    private String longtimeAbroad;

    /**
     * 地址信息
     */
    private String addressList;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司地区代码
     */
    private String companyAreaCode;

    /**
     * 公司电话
     */
    private String companyTelephone;

    /**
     * 职位
     */
    private String position;

    /**
     * 工作年限
     */
    private String workYear;

    /**
     * 薪资
     */
    private BigDecimal salary;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}