package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneUpdateRequest {
    /**
     * 保单发佣业务id
     */
    @Schema(description = "保单发佣业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fortuneBizId;

    /**
     * 发佣名称
     */
    @Schema(description = "发佣名称")
    private String fortuneName;

    /**
     * 发佣类型
     */
    @Schema(description = "发佣类型")
    private String fortuneType;

    /**
     * 发佣金额
     */
    @Schema(description = "发佣金额")
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @Schema(description = "发佣币种")
    private String currency;

    /**
     * 发佣日期
     */
    @Schema(description = "发佣日期")
    private Date payoutDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
