package com.yd.csf.feign.response.appointment;

import com.yd.csf.feign.dto.appointment.*;
import com.yd.csf.feign.dto.appointmentfile.ApiAppointmentFileDto;
import lombok.Data;

import java.util.List;

@Data
public class ApiAppointmentDetailResponse {

    /**
     * 预约状态: 0-暂存 1-待预约, 2-待签署 3-已签署 4-已取消（字典）
     */
    private Integer status;

    /**
     * 预约简要信息
     */
    private ApiAppointmentBriefInfoDto apiAppointmentBriefInfoDto;

    /**
     * 预约信息
     */
    private ApiAppointmentInfoDto apiAppointmentInfoDto;

    /**
     * 产品计划信息
     */
    private ApiProductPlanInfoDto apiProductPlanInfoDto;

    /**
     * 投保人信息
     */
    private ApiPolicyholderInfoDto apiPolicyholderInfoDto;

    /**
     * 受保人信息
     */
    private ApiInsurantInfoDto apiInsurantInfoDto;

    /**
     * 受益人列表信息
     */
    private List<ApiBeneficiaryInfoDto> apiBeneficiaryInfoDtoList;

    /**
     * 第二持有人信息
     */
    private ApiSecondHolderInfoDto apiSecondHolderInfoDto;

    /**
     * 预约附件信息列表
     */
    private List<ApiAppointmentFileDto> apiAppointmentFileDtoList;

}
