package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiPolicyholderService;
import com.yd.csf.feign.client.policyholder.ApiPolicyholderFeignClient;
import com.yd.csf.feign.dto.appointment.ApiPolicyholderInfoDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预约-投保人信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/policyholder")
@Validated
public class ApiPolicyholderController implements ApiPolicyholderFeignClient {

    @Autowired
    private ApiPolicyholderService apiPolicyholderService;

    /**
     * 编辑投保人信息
     * @param apiPolicyholderInfoDto
     * @return
     */
    @Override
    public Result edit(ApiPolicyholderInfoDto apiPolicyholderInfoDto) {
        return apiPolicyholderService.edit(apiPolicyholderInfoDto);
    }

    /**
     * 投保人信息详情
     * @param appointmentBizId 预约信息主表唯一业务ID
     * @param policyholderBizId 投保人信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiPolicyholderInfoDto> detail(String appointmentBizId,
                                                 String policyholderBizId) {
        return apiPolicyholderService.detail(appointmentBizId,policyholderBizId);
    }

}
