package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiInsurantService;
import com.yd.csf.feign.client.insurant.ApiInsurantFeignClient;
import com.yd.csf.feign.dto.appointment.ApiInsurantInfoDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预约-受保人信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/insurant")
@Validated
public class ApiInsurantController implements ApiInsurantFeignClient {

    @Autowired
    private ApiInsurantService apiInsurantService;

    /**
     * 编辑受保人信息
     * @param apiInsurantInfoDto
     * @return
     */
    @Override
    public Result edit(ApiInsurantInfoDto apiInsurantInfoDto) {
        return apiInsurantService.edit(apiInsurantInfoDto);
    }

    /**
     * 受保人信息详情
     * @param appointmentBizId 预约信息主表唯一业务ID
     * @param insurantBizId 受保人信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiInsurantInfoDto> detail(String appointmentBizId, String insurantBizId) {
        return apiInsurantService.detail(appointmentBizId,insurantBizId);
    }

}
