package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * 保单来佣表
 *
 * @TableName commission
 */
@TableName(value = "commission")
@Data
public class Commission implements Serializable {
    /**
     * serial id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应收账款编号 （非关联保单号，用应收账款编号比对）
     */
    private String receivableNo;

    /**
     * 保单来佣业务id
     */
    private String commissionBizId;

    /**
     * 入账检核年月 yyyy-MM
     */
    private String reconciliationYearMonth;

    /**
     * 应收款类型 R=关联保单应收单 U=非关联保单应收单
     */
    private String commissionBizType;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 期交保费
     */
    private String premium;

    /**
     * 保险公司 id
     */
    private String insuranceCompanyBizId;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 对账公司编码
     */
    private String reconciliationCompanyCode;

    /**
     * 对账公司业务id
     */
    private String reconciliationCompanyBizId;

    /**
     * 产品计划 id
     */
    private String productLaunchBizId;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    private Integer totalPeriod;

    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionType;

    /**
     * 来佣金额
     */
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    private String currency;

    /**
     * 结算汇率
     */
    private String exchangeRate;

    /**
     * 当前来佣比例
     */
    private BigDecimal currentCommissionRatio;

    /**
     * 当期已入账来佣比例
     */
    private BigDecimal periodPaidRatio;

    /**
     * 当期剩余来佣比例
     */
    private BigDecimal periodPendingRatio;

    /**
     * 来佣日期
     */
    private Date commissionDate;

    /**
     * 来佣状态 0=未比对 1=比对成功 2=比对失败
     */
    private String status;

    /**
     * 预计来佣业务id
     */
    private String commissionExpectedBizId;

    /**
     * 总金额
     */
    private BigDecimal expectedAmount;

    /**
     * 已入账金额
     */
    private BigDecimal paidAmount;

    /**
     * 待入账金额
     */
    private BigDecimal pendingAmount;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableLogic
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}