package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 查询fna请求
 */
@Schema(description = "查询fna请求")
@EqualsAndHashCode(callSuper = true)
@Data
public class FnaQueryRequest extends PageDto implements Serializable {

    /**
     * 创建时间开始
     */
    @Schema(description = "创建时间开始 2025-07-31 00:00:00",
            pattern = "yyyy-MM-dd HH:mm:ss", example = "2025-07-31 00:00:00", defaultValue = "2025-07-31 00:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;

    /**
     * 创建时间结束
     */
    @Schema(description = "创建时间结束 2025-07-31 23:59:59",
            pattern = "yyyy-MM-dd HH:mm:ss", example = "2025-07-31 23:59:59", defaultValue = "2025-07-31 23:59:59")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;

    /**
     * 流程编号
     */
    @Schema(description = "流程编号")
    private String fnaNo;

    /**
     * 状态
     */
    @Schema(description = "状态 字典值: csf_fna_status")
    private String status;

    /**
     * 客户姓名
     */
    @Schema(description = "客户姓名")
    private String customerName;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID")
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;


    private static final long serialVersionUID = 1L;
}