package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class PolicyUpdateRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 产品业务id
     */
    @Schema(description = "产品业务id")
    private String planBizId;

    /**
     * 产品代码
     */
    @Schema(description = "产品代码")
    private String productCode;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 产品险种
     */
    @Schema(description = "产品险种")
    private String productCate;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insurer;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insurerBizId;

    /**
     * 地区
     */
    @Schema(description = "地区")
    private String region;

    /**
     * 保單投保人业务id
     */
    @Schema(description = "保單投保人业务id")
    private String policyPolicyholderBizId;

    /**
     * 保單持有人名称
     */
    @Schema(description = "保單持有人名称")
    private String policyHolder;

    /**
     * 保单受保人业务id
     */
    @Schema(description = "保单受保人业务id")
    private String policyInsurantBizId;

    /**
     * 保单受保人名称
     */
    @Schema(description = "保单受保人名称")
    private String insured;

    /**
     * 供款年期（字典）
     */
    @Schema(description = "供款年期（字典）")
    private Integer paymentTerm;

    /**
     * 付款频率（字典）
     */
    @Schema(description = "付款频率（字典）")
    private String paymentFrequency;

    /**
     * 期交保费
     */
    @Schema(description = "期交保费")
    private BigDecimal paymentPremium;

    /**
     * 保单状态
     */
    @Schema(description = "保单状态 字典值：csf_policy_status")
    private String status;

    /**
     * 币种
     */
    @Schema(description = "币种")
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private Integer initialPremium;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期 格式：yyyy-MM-dd")
    private Date signDate;

    /**
     * 缮发日期
     */
    @Schema(description = "缮发日期 格式：yyyy-MM-dd")
    private Date issueDate;

    /**
     * 生效日期
     */
    @Schema(description = "生效日期 格式：yyyy-MM-dd")
    private Date effectiveDate;

    /**
     * 续保日期
     */
    @Schema(description = "续保日期 格式：yyyy-MM-dd")
    private Date renewalDate;

    /**
     * 是否预缴: 0-否, 1-是
     */
    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepaid;

    /**
     * 预付额
     */
    @Schema(description = "预付额")
    private String deductibles;

    /**
     * 预缴年期
     */
    @Schema(description = "预缴年期")
    private Integer prepaidTerm;

    /**
     * 首期付款方式（字典）
     */
    @Schema(description = "首期付款方式（字典）")
    private String initialPaymentMethod;

    /**
     * 续期付款方式（字典）
     */
    @Schema(description = "续期付款方式（字典）")
    private String renewalPaymentMethod;

    /**
     * 红利分配方式（字典）
     */
    @Schema(description = "红利分配方式（字典）")
    private String dividendDistributionMethod;

    /**
     * 保单日期回溯: 0-否, 1-是（字典）
     */
    @Schema(description = "保单日期回溯: 0-否, 1-是（字典）")
    private Integer isBacktrack;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    @Schema(description = "是否参加递增保障权益: 0-否, 1-是（字典）")
    private Integer isJoin;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
