package com.yd.csf.feign.fallback.productplan;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.productplan.ApiProductPlanFeignClient;
import com.yd.csf.feign.dto.appointment.ApiProductPlanInfoDto;
import com.yd.csf.feign.dto.appointment.ApiProductPlanMainInfoDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-产品计划信息Feign降级处理
 */
@Slf4j
@Component
public class ApiProductPlanFeignFallbackFactory implements FallbackFactory<ApiProductPlanFeignClient> {
    @Override
    public ApiProductPlanFeignClient create(Throwable cause) {
        return new ApiProductPlanFeignClient() {
            @Override
            public Result edit(ApiProductPlanMainInfoDto apiProductPlanMainInfoDto) {
                return null;
            }

            @Override
            public Result editPlan(ApiProductPlanInfoDto apiProductPlanInfoDto) {
                return null;
            }

            @Override
            public Result<ApiProductPlanInfoDto> detail(String appointmentBizId, String planBizId) {
                return null;
            }
        };
    }
}
