package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.Fortune;
import com.yd.csf.service.model.FortuneAccount;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneVO implements Serializable {

    /**
     * 保单发佣业务id
     */
    @Schema(description = "保单发佣业务id")
    private String fortuneBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    @Schema(description = "发佣总期数")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人
     */
    @Schema(description = "转介人")
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "转介人业务ID")
    private String brokerBizId;

    /**
     * 所属团队
     */
    @Schema(description = "所属团队")
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队业务ID")
    private String teamBizId;

    /**
     * 发佣名称
     */
    @Schema(description = "发佣名称")
    private String fortuneName;

    /**
     * 发佣类型
     */
    @Schema(description = "发佣类型")
    private String fortuneType;

    /**
     * 发佣金额
     */
    @Schema(description = "发佣金额")
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @Schema(description = "发佣币种")
    private String currency;

    /**
     * 佣金发放状态 0=暂不可发 1=可发放 2=已发并关账
     */
    @Schema(description = "佣金发放状态 0=暂不可发 1=可发放 2=已发并关账 字典值：csf_fortune_status")
    private String status;

    /**
     * 发佣日期
     */
    @Schema(description = "发佣日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date payoutDate;

    /**
     * 是否含税 0=No, 1=Yes
     */
    @Schema(description = "是否含税 0=No, 1=Yes")
    private Integer isTax;

    /**
     * 应缴税额
     */
    @Schema(description = "应缴税额")
    private BigDecimal taxAmount;

    /**
     * 税后发佣
     */
    @Schema(description = "税后发佣")
    private BigDecimal netAmount;

    /**
     * 薪资单业务id
     */
    @Schema(description = "薪资单业务id")
    private String salaryBizId;

    /**
     * 基本法id
     */
    @Schema(description = "基本法id")
    private String baseRuleBizId;

    /**
     * 计算规则id
     */
    @Schema(description = "计算规则id")
    private String settlementBizId;

    /**
     * 计算公式
     */
    @Schema(description = "计算公式")
    private String calculationFormula;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    /**
     * 创建人ID
     */
    @Schema(description = "创建人ID")
    private String creatorId;

    /**
     * 更新人ID
     */
    @Schema(description = "更新人ID")
    private String updaterId;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    /**
     * 对象转封装类
     *
     * @param fortune
     * @return
     */
    public static FortuneVO objToVo(Fortune fortune) {
        if (fortune == null) {
            return null;
        }
        FortuneVO fortuneVO = new FortuneVO();
        BeanUtils.copyProperties(fortune, fortuneVO);

        return fortuneVO;
    }
}
