package com.yd.csf.feign.client.productplan;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiProductPlanInfoDto;
import com.yd.csf.feign.dto.appointment.ApiProductPlanMainInfoDto;
import com.yd.csf.feign.fallback.productplan.ApiProductPlanFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 香港保险服务-产品计划信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiProductPlanFeignFallbackFactory.class)
public interface ApiProductPlanFeignClient {

    /**
     * 编辑产品计划主体信息
     * @param apiProductPlanMainInfoDto
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiProductPlanMainInfoDto apiProductPlanMainInfoDto);

    /**
     * 编辑产品计划信息
     * @param apiProductPlanInfoDto
     * @return
     */
    @PutMapping("/edit/plan")
    Result editPlan(@Validated @RequestBody ApiProductPlanInfoDto apiProductPlanInfoDto);

    /**
     * 产品计划详情-根据产品计划信息表唯一业务ID查询
     * @param appointmentBizId 预约信息主表唯一业务ID
     * @param planBizId 产品计划信息表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiProductPlanInfoDto> detail(@RequestParam(value = "appointmentBizId") String appointmentBizId,
                                         @RequestParam(value = "planBizId") String planBizId);
}
