package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.result.Result;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.PolicyAdditional;
import com.yd.csf.service.service.*;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * policy_additional接口
 *
 * @author jianan
 * @since 2025-09-20
 */
@RestController
@RequestMapping("/policy_additional")
@Tag(name = "保单附加险接口")
public class ApiPolicyAdditionalController {

    @Resource
    private PolicyAdditionalService policyAdditionalService;

    /**
     * 创建保单附加险
     *
     * @param policyAdditionalAddRequest
     * @param request
     * @return
     */
    @Operation(summary = "创建保单附加险")
    @PostMapping("/add")
    public Result<Map<String, Object>> addPolicyAdditional(@RequestBody PolicyAdditionalAddRequest policyAdditionalAddRequest, HttpServletRequest request) {
        if (policyAdditionalAddRequest == null) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        return Result.success(policyAdditionalService.addPolicyAdditional(policyAdditionalAddRequest));
    }

    /**
     * 根据 id 删除保单附加险
     *
     * @param id 保单附加险信息表主键id
     * @param request
     * @return
     */
    @DeleteMapping("/delete")
    @Operation(summary = "根据 id 删除保单附加险")
    public Result<Boolean> deletePolicyAdditional(@RequestParam("id") Long id, HttpServletRequest request) {
        if (id == null || id <= 0) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "id不能为空");
        }
//        User user = userService.getLoginUser(request);
        // 判断是否存在
        PolicyAdditional policyAdditional = policyAdditionalService.getById(id);
        if (policyAdditional == null) {
            return Result.fail(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }
        // 仅本人或管理员可删除
//        if (!oldFna.getUserId().equals(user.getId()) && !userService.isAdmin(request)) {
//            throw new BusinessException(ErrorCode.NO_AUTH_ERROR);
//        }

        // 操作数据库
        return Result.success(policyAdditionalService.removeById(id));
    }

    /**
     * 更新保单附加险（产品计划）
     *
     * @param policyUpdateRequest
     * @return
     */
    @PostMapping("/update")
    @Operation(summary = "更新保单附加险信息")
    public Result<Boolean> updatePolicyAdditional(@RequestBody PolicyAdditionalUpdateRequest policyUpdateRequest) {
        if (policyUpdateRequest == null || policyUpdateRequest.getPolicyAdditionalBizId() == null) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        return Result.success(policyAdditionalService.updatePolicyAdditional(policyUpdateRequest));
    }

    /**
     * 根据 policyBizId 获取保单附加险（封装类）
     *
     * @param policyAdditionalBizId
     * @return
     */
    @GetMapping("/get/vo")
    @Operation(summary = "根据 policyBizId 获取保单附加险详情")
    public Result<PolicyAdditional> getPolicyByPolicyAdditionalBizId(@RequestParam("policyAdditionalBizId") String policyAdditionalBizId, HttpServletRequest request) {
        if (policyAdditionalBizId == null) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        // 查询数据库
        PolicyAdditional policyAdditional = policyAdditionalService.getByBizId(policyAdditionalBizId);
        if (policyAdditional == null) {
            return Result.fail(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }

        // 获取封装类
        return Result.success(policyAdditional);
    }
    
    /**
     * 分页获取保单附加险列表
     *
     * @param PolicyQueryRequest
     * @param request
     * @return
     */
    @PostMapping("/list")
    @Operation(summary = "分页获取保单附加险列表")
    public Result<Page<PolicyAdditional>> listPolicyByPage(@RequestBody PolicyAdditionalQueryRequest PolicyQueryRequest,
                                                               HttpServletRequest request) {
        long current = PolicyQueryRequest.getPageNo();
        long size = PolicyQueryRequest.getPageSize();

        // 查询数据库
        QueryWrapper<PolicyAdditional> queryWrapper = new QueryWrapper<PolicyAdditional>();
        queryWrapper.eq("policy_biz_id", PolicyQueryRequest.getPolicyBizId());
        queryWrapper.orderByAsc("id");
        Page<PolicyAdditional> policyAdditionalPage = policyAdditionalService.page(new Page<>(current, size),
                queryWrapper);
        // 获取封装类
        return Result.success(policyAdditionalPage);
    }

}
