package com.yd.csf.api.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

@Data
public class PolicyExcelDTO {

    @ExcelProperty("保单状态")
    private String status;

    @NotBlank(message = "保单号不能为空")
    @ExcelProperty("保单号")
    private String policyNo;

    @ExcelProperty("签单日期")
    private Date signDate;

    @ExcelProperty("生效日期")
    private Date effectiveDate;

    @ExcelProperty("冷静期天数")
    private Integer coolingOffDays;

    @ExcelProperty("续保日期")
    private Date renewalDate;

    @ExcelProperty("供款年期")
    private Integer paymentTerm;

    @ExcelProperty("是否预缴")
    private String isPrepaid;

    @ExcelProperty("预缴年期")
    private Integer prepaidTerm;

    @ExcelProperty("产品名称")
    private String productName;

    @ExcelProperty("产品类别")
    private String productCate;

    @ExcelProperty("保险公司")
    private String insurer;

    @ExcelProperty("对账公司")
    private String reconciliationCompany;

    @ExcelProperty("保單持有人")
    private String policyHolder;

    @ExcelProperty("受保人")
    private String insured;

    @ExcelProperty("保单币种")
    private String currency;

    @ExcelProperty(value = "首期保费（不含徽费，预缴保费）", index = 16)
    private String initialPremium;

    @ExcelProperty("签单人")
    private String signer;

    @ExcelProperty("转介人1")
    private String brokerName1;

    @ExcelProperty("所属团队1")
    private String team1;

    @ExcelProperty("介绍费占比1")
    private String brokerRatio1;

    @ExcelProperty("转介人2")
    private String brokerName2;

    @ExcelProperty("所属团队2")
    private String team2;

    @ExcelProperty("介绍费占比2")
    private String brokerRatio2;

    @ExcelProperty("转介人3")
    private String brokerName3;

    @ExcelProperty("所属团队3")
    private String team3;

    @ExcelProperty("介绍费占比3")
    private String brokerRatio3;

    @ExcelProperty("转介人4")
    private String brokerName4;

    @ExcelProperty("所属团队4")
    private String team4;

    @ExcelProperty("介绍费占比4")
    private String brokerRatio4;

    @ExcelProperty("转介人5")
    private String brokerName5;

    @ExcelProperty("所属团队5")
    private String team5;

    @ExcelProperty("介绍费占比5")
    private String brokerRatio5;
}
